/*:
 * @plugindesc Call a common event using a keypress. 
 * Modified GALV_JumpAbility.js - galvs-scripts.com
 * 
 * @author Procraftynation - procrastination done right!
 *
 * @param Key
 * @desc See help file for available keys. This key will also act as "cancel" key
 * @default c
 
 * @param Common Event ID
 * @desc The common event ID to be called for allowed regions
 * @default 1
 *
 * @param Mode
 * @desc If allow, Key press will only work on specified Regions. 
 * If block, Key press will not work on specified Regions.
 * @default block
 *
 * @param Regions
 * @desc Region ID's that are allowed or blocked for Key press
 * @default 255,254
 *
 *
 * @help
 *  Call Common Event Key
 * ----------------------------------------------------------------------------
 *  KEY
 * ----------------------------------------------------------------------------
 * This plugin mostly uses default RPGMaker MV controls for the jump key
 * setup. It also allows use of other keyboard keys but whatever key you
 * choose, I advise you to test it isn't conflicting with another control.
 * ----------------------------------------------------------------------------
 * Possible keys to use for "Key" setting:
 *  tab
 *  enter                // Not recommended as key already used
 *  shift                // Not recommended as key already used
 *  ctrl
 *  alt
 *  space                // Not recommended as key already used
 *  0-9
 *  a-z                  // Q,W,Z,X are not recommended as they are used
 *  semi-colon
 *  comma
 *  period
 *  single quote
 * ----------------------------------------------------------------------------
 *  MODE
 * ----------------------------------------------------------------------------
 * Value is allow or block. 
 * If allow, Key press will only work on specified Regions. 
 * If block, Key press will not work on specified Regions.
 * ----------------------------------------------------------------------------
 *  REGIONS
 * ----------------------------------------------------------------------------
 * Region ID's can be set in the settings. Depending on the Mode,
 * the Key press is either allowed or blocked on the regions specified. 
 * Separate multiple region ID's with commas.
 * ----------------------------------------------------------------------------
 */




(function() {
	var DEX = DEX || {};          // DEX's main object
	DEX.CCEK = DEX.CCEK || {};        // Object Alias for Call Common Event Key 
	DEX.CCEK.key = PluginManager.parameters('DEX_CallCommonEventKey')["Key"].toLowerCase();
	DEX.CCEK.mode = PluginManager.parameters('DEX_CallCommonEventKey')["Mode"].toLowerCase();
	DEX.CCEK.commondEventId = PluginManager.parameters('DEX_CallCommonEventKey')["Common Event ID"];
	
	DEX.CCEK.regions = function () {
		var arr = PluginManager.parameters('DEX_CallCommonEventKey')["Regions"].split(",");
		for (i = 0;i < arr.length;i++) {
			arr[i] = Number(arr[i]);
		};
		return arr;
	}();
	

	// Potential keys user can add:
	var txt_ids = {
	"tab":9,"enter":13,"shift":16,"ctrl":17,"alt":18,"space":32,"0":48,"1":49,"2":50,"3":51,"4":52,"5":53,"6":54,
	"7":55,"8":56,"9":57,"a":65,"b":66,"c":67,"d":68,"e":69,"f":70,"g":71,"h":72,"i":73,"j":74,"k":75,"l":76,"m":77,
	"n":78,"o":79,"p":80,"q":81,"r":82,"s":83,"t":84,"u":85,"v":86,"w":87,"x":88,"y":89,"z":90,"semi-colon":186,
	"comma":188,"period":190,"single quote":222,
	};

	// Add key to 'cancel' input. This is so gamepad works and user can still add a keyboard key.
	Input.keyMapper[txt_ids[DEX.CCEK.key]] = 'cancel';

	// Special trigger so the cancel command doesn't call menu and the common event
	Input.isButtonTriggered = function(keyName) {
		return this._latestButton === keyName && this._pressedTime === 0;
	};


	var DEX_Game_Player_moveByInput = Game_Player.prototype.moveByInput;
	Game_Player.prototype.moveByInput = function() {
		//if (this.isMoving()) return;
		if (this._priorityType == 1.5) this._priorityType = 1;
		
		if (this.canMove() && Input.isButtonTriggered('cancel') && this.isNormal) {			
			var x = $gamePlayer.x;
			var y = $gamePlayer.y;
			if(DEX.CCEK.checkBlock(x,y)) {
				$gameTemp.reserveCommonEvent(DEX.CCEK.commondEventId);
			}
		};
		DEX_Game_Player_moveByInput.call(this);
	};
    
	DEX.CCEK.checkBlock = function(x,y) {
		if(DEX.CCEK.mode == "allow") {
			return DEX.CCEK.regions.contains($gameMap.regionId(x,y));	
		}
		return !DEX.CCEK.regions.contains($gameMap.regionId(x,y));
	};
	
})();